﻿USE [CC_REFDOC]
GO

/****** Object:  StoredProcedure [App].[NVCC_usp_GetPatientsByPartialNameAndSsn]    Script Date: 11/17/2017 3:46:30 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [App].[NVCC_usp_GetPatientsByPartialNameAndSsn]
	@lastFourOfSsn varchar(4),
	@lastNameStartsWith varchar(50),
	@firstNameStartsWith varchar(50) = null,
	@firstFiveOfSsn varchar(5) = null

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Tamer Rifai 
--Object/SP Name        : NVCC_usp_GetPatientsByPartialNameAndSsn
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 11-17-2017
--
--Last Changed          : 11-17-2017
--Last Changed By		: Tamer Rifai 
--Reason For Change		: N/A
--
--Purpose               : To retrieve all patients matched by a required last 4 of SSN and some portion of last name (and possibly full SSN and First name).
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

	  SELECT
	   a.[PatientSID]
      ,a.[PatientIEN]
	  ,a.[PatientICN]
      ,a.[Sta3n] as Station
	  ,a.[PatientSSN]
      ,a.[PatientName]
	  ,a.BirthDateTime as [DateOfBirth]
	  ,a.DeathDateTime as [DateOfDeath]

      --,a.[PatientLastName]
      --,a.[PatientFirstName]
      
      --,a.[ScrSSN]
      
      --,a.[MedicaidNumber]
      --,a.[Gender]
      --,a.[Age]
      --,a.DeceasedFlag as [Deceased]
      
      --,a.PseudoSSNReason as [PseudoSSNFlag]
      --,a.PseudoSSNReason as [PeriodOfServiceSID]
      --,a.[PeriodOfService]
      --,a.[CurrentMeansTestStatusSID]
      --,a.[MaritalStatusSID]
      --,a.[MaritalStatus]
      --,a.[InsuranceCoverageFlag]
      --,a.[ReligionSID]
      --,a.[Religion]
      --,a.[VeteranFlag]
      --,a.[TestPatientFlag]
      --,a.[CDWPossibleTestPatientFlag]
      --,a.PatientEnteredDateTime as [EnteredIntoFileDate]
      --,a.PatientEnteredVistaErrorDate as [EnteredIntoFileVistaErrorDate]
      --,a.PatientEnteredDateTimeTransformSID as [EnteredIntoFileDateTransformSID]
      --,a.[EmergencyResponseIndicator]
      --,a.[EligibilitySID]
      --,a.[Eligibility]
      --,a.[EligibilityVACode]
      
      --,a.[SensitiveFlag]
      --,a.[PreferredInstitutionSID]      
      --,a.IneligibleDateTime as [IneligibleDate]
      --,a.[IneligibleVistaErrorDate]
      --,a.IneligibleDateTimeTransformSID as [IneligibleDateTransformSID]
      --,a.[IneligibleReason]
      --,a.[EligibilityStatus]
      --,a.[EligibilityVerificationSource]
   FROM  CDWWork.SPatient.SPatient a 
	WHERE
		a.PatientSSN like '%' + @lastFourOfSsn
		AND a.PatientLastName like @lastNameStartsWith + '%'
		AND a.PatientName <>'*Unknown at this time*'
		AND a.PatientName is not null
		AND (@firstFiveOfSsn is null OR a.PatientSSN like @firstFiveOfSsn + '%')
		AND (@firstNameStartsWith is null OR a.PatientFirstName like @firstNameStartsWith + '%')
		
END;


GO


